<?php

/**
 * Bot Configuration File Example
 * Copy this file to config.php and fill in your values
 */

// Telegram Bot Configuration
define('API_ID', 0);  // Your API ID from my.telegram.org
define('API_HASH', '');  // Your API Hash from my.telegram.org
define('BOT_TOKEN', '');  // Your Bot Token from @BotFather

// Admin User IDs (comma-separated)
define('ADMIN_IDS', []);  // e.g., [123456789, 987654321]

// Payment Configuration
define('PAYMENT_CONFIG_CHAT_ID', 0); // Replace with the Channel/Group ID for payment receipts

// Database Configuration
define('DATABASE', __DIR__ . '/bot6-real.db');

// Webhook Configuration
define('WEBHOOK_URL', 'https://yourdomain.com/webhook.php');

// Telegram API Base URL
define('TELEGRAM_API', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

// Enable error reporting for debugging (set to false in production)
define('DEBUG_MODE', true);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/error.log');
}

// Timezone setting
date_default_timezone_set('Asia/Tehran');

?>

