<?php

/**
 * Database Migration Script
 * Run this script ONCE after updating the code to migrate the database schema
 */

require_once 'config.php';
require_once 'database.php';

echo "=== Database Migration Started ===\n\n";

try {
    // Run init_db to create new tables
    echo "Creating new tables (channel_lock_stats)...\n";
    init_db();
    echo "✓ Tables created/verified\n\n";

    // Migrate channels table to add created_at column
    echo "Migrating channels table...\n";
    migrate_channels_table();
    echo "✓ Channels table migrated\n\n";

    echo "=== Migration Completed Successfully ===\n\n";
    echo "You can now use the channel lock tracking features!\n";
    echo "The new features include:\n";
    echo "- Track users who view channel locks\n";
    echo "- Track users who were already members\n";
    echo "- Track users who joined through the lock\n";
    echo "- Track users who didn't join\n";
    echo "- View statistics for each channel lock\n\n";
    echo "To view statistics:\n";
    echo "1. Go to admin panel\n";
    echo "2. Click 'قفل کانال'\n";
    echo "3. Click on any channel\n";
    echo "4. Click 'مشاهده آمار'\n\n";

} catch (Exception $e) {
    echo "❌ Error during migration: " . $e->getMessage() . "\n";
    echo "Please contact support if this error persists.\n";
}

?>
