<?php

/**
 * Migration Script for Seen/Reaction Locks Feature
 * Run this script ONCE to add seen/reaction lock tables
 */

require_once 'config.php';
require_once 'database.php';

echo "=== Seen/Reaction Locks Migration Started ===\n\n";

try {
    // Run init_db to create new tables
    echo "Creating new tables (seen_reaction_locks, user_lock_progress)...\n";
    init_db();
    echo "✓ Tables created/verified\n\n";

    echo "=== Migration Completed Successfully ===\n\n";
    echo "New features enabled:\n";
    echo "- Seen/Reaction lock system with timer\n";
    echo "- Sequential lock progression\n";
    echo "- Up to 10 locks per bot\n";
    echo "- User progress tracking\n\n";
    echo "Admin Panel Changes:\n";
    echo "- New button: '👁 قفل سین/ریاکشن'\n";
    echo "- Add seen or reaction locks\n";
    echo "- Set custom timer for each lock\n";
    echo "- View and remove locks\n";
    echo "- Locks shown in order\n\n";
    echo "User Experience:\n";
    echo "- After channel locks, users see seen/reaction locks\n";
    echo "- Each lock has custom message and timer\n";
    echo "- Must wait for timer before clicking 'انجام شد'\n";
    echo "- Locks shown sequentially (one by one)\n";
    echo "- Files sent after completing all locks\n\n";
    echo "To add locks:\n";
    echo "1. Send /start to bot as admin\n";
    echo "2. Click '👁 قفل سین/ریاکشن'\n";
    echo "3. Click '➕ افزودن قفل'\n";
    echo "4. Choose lock type (سین/ریاکشن)\n";
    echo "5. Enter message text (can include links)\n";
    echo "6. Enter timer in seconds\n\n";
    echo "Limits:\n";
    echo "- Maximum 10 locks per bot\n";
    echo "- Timer must be > 0 seconds\n";
    echo "- Locks execute in order\n\n";

} catch (Exception $e) {
    echo "❌ Error during migration: " . $e->getMessage() . "\n";
    echo "Please contact support if this error persists.\n";
}

?>
